/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : D/I and D/O
/* - Contents:  α׷ COMI_DI_GetAll(..) COMI_DO_PutAll(..) Լ 
/*    Ͽ D/I D/O 8ä ÿ Ʋϴ Դϴ.
/* - Remarks : 
/*     1.   COMI-SD101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMI_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101

void main (void)
{
	HANDLE hDevice;
	ULONG do_states=0, di_states;
	int di_each[8], i;

	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}
	
	printf("DIO ׽Ʈ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	/*   Digital Input/Output   ϴ ̹Ƿ	*/
	/* COMI-CP401  쿡 DI/DO   ϱ  		*/
	/* ⼭ COMI_DIO_SetUsage(DO_DI)  ־ մϴ.  		*/
	if(DEV_ID == COMI_CP401)
		COMI_DIO_SetUsage(hDevice, DO_DI);

	while(!kbhit())
	{
		do_states = ~do_states;  //  D/O ä On/Off state  
		COMI_DO_PutAll (hDevice, do_states); // Put D/O  
		
		/* Get D/I and print on screen */
		di_states = COMI_DI_GetAll(hDevice);
		/* di_states  ä state  ִ.         */
		/*  ä ¸    bit mask   */
		/*  ϸ ȴ.                                    */
		for(i=0; i<8; i++)
			di_each[i] = (di_states >> i) & 0x1;
		printf("States of DI0 ~ DI7 = %d %d %d %d %d %d %d %d\n",
				di_each[0], di_each[1], di_each[2], di_each[3],
				di_each[4], di_each[5], di_each[6], di_each[7]);
		Sleep(500);
	}

	
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
